<?php
/* iTag Free WordPress Theme */

get_header(); ?>

<div id="content" class="column640">

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

	<div <?php post_class('clear') ?> id="post-<?php the_ID(); ?>">
		<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php _e('Permanent Link to', 'itag-lang'); ?> <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
		<div class="column140 postInfos">
			<p class="infodate"><strong><?php the_time(__('d M Y', 'itag-lang')); ?></strong> <?php _e('at', 'itag-lang'); ?> <?php the_time(__('H:i', 'itag-lang')); ?></p>
			<p class="infoauthor"><strong><?php the_author() ?></strong></p>
			<p class="infocat"><?php the_category(', ') ?></p>
			<?php the_tags('<p class="infotags">', ' ', '</p>'); ?>
			<?php edit_post_link(__('Edit', 'itag-lang'), '<p>', '</p>'); ?>
		</div>
		<div class="column480 postContent clear">
			<?php the_content(__('Continue reading', 'itag-lang').' &rarr;'); ?>
			<?php wp_link_pages(array('before' => '<p class="pagination"><span>'.__('Pages', 'itag-lang').'</span> ', 'after' => '</p>', 'pagelink' => '<strong>%</strong>')); ?>
		</div>
	</div>

<?php endwhile; ?>

	<div class="navigation clear">
		<div class="left"><?php previous_post_link('&larr; %link') ?></div>
		<div class="right"><?php next_post_link('%link &rarr;') ?></div>
	</div>

	<?php comments_template(); ?>

<?php endif; ?>

</div>

<?php get_sidebar(); ?>
<?php get_footer(); ?>