<?php
/* iTag Free WordPress Theme */

get_header(); ?>

<div id="content" class="column640">

	<?php if (have_posts()) : ?>

		<h2><?php _e('Search Results', 'itag-lang'); ?></h2>

		<?php while (have_posts()) : the_post(); ?>

		<div <?php post_class('clear') ?> id="post-<?php the_ID(); ?>">
			<h3><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php _e('Permanent Link to'); ?> <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h3>
			<div class="column140 postInfos">
				<p><strong><?php the_time(__('d M Y', 'itag-lang')); ?></strong> <?php _e('at', 'itag-lang'); ?> <?php the_time(__('H:i', 'itag-lang')); ?></p>
				<p><strong><?php the_author() ?></strong></p>
				<p><?php the_category(', ') ?></p>
				<p><?php comments_popup_link(__('No Comment', 'itag-lang'), __('1 Comment', 'itag-lang'), __('% Comments', 'itag-lang')); ?></p>
				<?php edit_post_link(__('Edit', 'itag-lang'), '<p>', '</p>'); ?>
			</div>
			<div class="column480 postContent clear">
				<?php the_excerpt(); ?>
			</div>
		</div>

		<?php endwhile; ?>

		<div class="navigation clear">
			<div class="left"><?php next_posts_link('&larr; '.__('Older Entries', 'itag-lang')) ?></div>
			<div class="right"><?php previous_posts_link(__('Newer Entries', 'itag-lang').' &rarr;') ?></div>
		</div>

	<?php else : ?>

		<h2><?php _e('No posts found.', 'itag-lang'); ?></h2>
		<h3><?php _e('Try a different search?', 'itag-lang'); ?></h3>
		<div class="column480" style="margin-left:160px">
			<?php get_search_form(); ?>
		</div>

	<?php endif; ?>

</div>

<?php get_sidebar(); ?>
<?php get_footer(); ?>