<?php
/* iTag Free WordPress Theme */

get_header(); ?>

<div id="content" class="column640">

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

	<div <?php post_class('clear') ?> id="post-<?php the_ID(); ?>">
		<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php _e('Permanent Link to', 'itag-lang'); ?> <?php the_title_attribute(); ?>"><?php the_title(); ?></a></h2>
		<div class="column140 postInfos">
			<p class="infodate"><strong><?php the_time(__('d M Y', 'itag-lang')); ?></strong> <?php _e('at', 'itag-lang'); ?> <?php the_time(__('H:i', 'itag-lang')); ?></p>
			<p class="infoauthor"><strong><?php the_author() ?></strong></p>
			<p class="infocat"><?php the_category(', ') ?></p>
			<p class="infocomment"><?php comments_popup_link(__('No Comments', 'itag-lang'), __('1 Comment', 'itag-lang'), __('% Comments', 'itag-lang')); ?></p>
			<?php edit_post_link(__('Edit', 'itag-lang'), '<p>', '</p>'); ?>
		</div>
		<div class="column480 postContent clear">
			<?php show_thumb(160,120);?>
			<?php the_excerpt_reloaded(50, '<a>', 'content', true, __('Continue reading', 'itag-lang').' &rarr;', true);?>
		</div>
	</div>

<?php endwhile; ?>

	<div class="navigation clear">
		<div class="left"><?php next_posts_link('&larr; '.__('Older Entries', 'itag-lang')) ?></div>
		<div class="right"><?php previous_posts_link(__('Newer Entries', 'itag-lang').' &rarr;') ?></div>
	</div>

<?php endif; ?>

</div>

<?php get_sidebar(); ?>
<?php get_footer(); ?>