<?php
/* iTag Free WordPress Theme */

automatic_feed_links();

wp_enqueue_script('theme_functions', get_bloginfo('template_url').'/js/functions.js', array('jquery'));

load_theme_textdomain('itag-lang', TEMPLATEPATH.'/lang/');

if ( function_exists('register_sidebar') ) {
 	register_sidebar(array(
 	'name' 			=> 'Sidebar Top',
 	'before_widget' => '<div id="%1$s" class="widget %2$s">',
 	'after_widget'  => '</div>',
 	'before_title'  => '<h3 class="widgettitle">',
 	'after_title'	=> '</h3>'));

 	register_sidebar(array(
 	'name' 			=> 'Sidebar Left',
 	'before_widget' => '<div id="%1$s" class="widget %2$s">',
 	'after_widget'  => '</div>',
 	'before_title'  => '<h3 class="widgettitle">',
 	'after_title'	=> '</h3>'));

 	register_sidebar(array(
 	'name' 			=> 'Sidebar Right',
 	'before_widget' => '<div id="%1$s" class="widget %2$s">',
 	'after_widget'  => '</div>',
 	'before_title'  => '<h3 class="widgettitle">',
 	'after_title'	=> '</h3>'));

 	register_sidebar(array(
 	'name' 			=> 'Sidebar Bottom',
 	'before_widget' => '<div id="%1$s" class="widget %2$s">',
 	'after_widget'  => '</div>',
 	'before_title'  => '<h3 class="widgettitle">',
 	'after_title'	=> '</h3>'));
}

function itag_comments($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment; ?>
   	<li class="clear" id="comment-<?php comment_ID() ?>">
    	<div <?php comment_class('clear'); ?>>
	   		<div class="column140">
	   			<?php comment_type('', '<p>'.__('Trackback', 'itag-lang').'</p>', '<p>'.__('Pingback', 'itag-lang').'</p>'); ?>
	   			<p class="infoauthor"><?php _e('by', 'itag-lang'); ?> <strong><?php comment_author_link() ?></strong></p>
	   			<p class="infodate"><strong><?php comment_date(__('d M Y', 'itag-lang')) ?></strong> <?php _e('at', 'itag-lang'); ?> <a href="#comment-<?php comment_ID() ?>"><?php comment_time(__('H:i', 'itag-lang')) ?></a></p>
	   			<?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
	   			<?php edit_comment_link(__("Edit", 'itag-lang'), '<p>', '</p>'); ?>
	   		</div>

	   		<div class="column480 clear">
	       		<?php echo get_avatar( $comment, 50 ); ?>
	   			<?php if ($comment->comment_approved == '0') : ?>
	   				<p><em><?php _e('Your comment is awaiting moderation.') ?></em></p>
	   			<?php endif; ?>
	   			<?php comment_text() ?>
	   		</div>
   		</div>
<?php
}

/********************************************************************
Creating a thumbnail
********************************************************************/
function show_thumb($width,$height) {

	global $post;
	$custom_field_value = get_post_meta($post->ID, 'Image', true);
	$video_field = get_post_meta($post->ID, 'Video', true);
	$attachments = get_children( array('post_parent' => $post->ID, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => 'ASC', 'orderby' => 'menu_order ID', 'numberposts' => 1) );

	if ($attachments == true) {

		foreach($attachments as $id => $attachment) {
		$img = wp_get_attachment_image_src($id, 'full');
		$img_url = parse_url($img[0], PHP_URL_PATH);
			print '<a href="'.get_permalink($post).'" title="'.$post->post_title.'"><img src="'.get_template_directory_uri().'/js/phpThumb/phpThumb.php?src='.$img_url.'&amp;w='.$width.'&amp;h='.$height.'&amp;zc=T&amp;q=95" title="'.$post->post_title.'" alt="'.$post->post_title.'" class="thumbpost" style="margin-right:5px;"/></a>';
		}

	} elseif ( $custom_field_value == true) {
		$tweak = str_replace('/', '%2F', $custom_field_value);
		$img_url = str_replace(':', '%3A', $tweak);
			print '<a href="'.get_permalink($post).'" title="'.$post->post_title.'"><img src="'.get_template_directory_uri().'/js/phpThumb/phpThumb.php?src='.$img_url.'&amp;w='.$width.'&amp;h='.$height.'&amp;zc=T&amp;q=95" title="'.$post->post_title.'" alt="'.$post->post_title.'" class="thumbpost" style="margin-right:5px;"/></a>';

	} elseif ( $video_field == true) {

					if(eregi('youtube.com',$video_field)){
						$position       = strpos($video_field, 'watch?v=')+8;
						$remove_length  = strlen($video_field)-$position;
						$youtube_id       = substr($video_field, -$remove_length, 11);
						print '<img src="'.get_template_directory_uri().'/js/phpThumb/phpThumb.php?src=http://i.ytimg.com/vi/'.$youtube_id.'/default.jpg&amp;w='.$width.'&amp;h='.$height.'&amp;zc=T&amp;q=95" title="'.$post->post_title.'" alt="'.$post->post_title.'" class="thumbpost"/>';

					} elseif(eregi('vimeo.com',$video_field)){
					    $file = fopen($video_field, "r");
					    $filedata = stream_get_contents($file);
					    $html_content = strpos($filedata,"<link rel=\"videothumbnail");
					    $link_string = substr($filedata, $html_content, 128);
					    $video_id_array = explode("\"", $link_string);
					    $thumbnail_url = $video_id_array[3];
						print '<img src="'.get_template_directory_uri().'/js/phpThumb/phpThumb.php?src='.$thumbnail_url.'&amp;w='.$width.'&amp;h='.$height.'&amp;zc=T&amp;q=95" title="'.$post->post_title.'" alt="'.$post->post_title.'" class="thumbpost"/>';
					}

	} else {

		$img_url = '';
		ob_start();
		ob_end_clean();
		$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
		$img_url = $matches[1][0];
		if($img_url){
			print '<a href="'.get_permalink($post).'" title="'.$post->post_title.'"><img src="'.get_template_directory_uri().'/js/phpThumb/phpThumb.php?src='.$img_url.'&amp;w='.$width.'&amp;h='.$height.'&amp;zc=T&amp;q=95" title="'.$post->post_title.'" alt="'.$post->post_title.'" class="thumbpost" style="margin-right:5px;"/></a>';
		} else {
			print '';
		}

	}

}

/********************************************************************
The Excerpt Reloaded
********************************************************************/

function wp_the_excerpt_reloaded($args='') {
	parse_str($args);
	if(!isset($excerpt_length)) $excerpt_length = 120; // length of excerpt in words. -1 to display all excerpt/content
	if(!isset($allowedtags)) $allowedtags = '<a>'; // HTML tags allowed in excerpt, 'all' to allow all tags.
	if(!isset($filter_type)) $filter_type = 'none'; // format filter used => 'content', 'excerpt', 'content_rss', 'excerpt_rss', 'none'
	if(!isset($use_more_link)) $use_more_link = 1; // display
	if(!isset($more_link_text)) $more_link_text = "(more...)";
	if(!isset($force_more)) $force_more = 1;
	if(!isset($fakeit)) $fakeit = 1;
	if(!isset($fix_tags)) $fix_tags = 1;
	if(!isset($no_more)) $no_more = 0;
	if(!isset($more_tag)) $more_tag = 'div';
	if(!isset($more_link_title)) $more_link_title = 'Continue reading';
	if(!isset($showdots)) $showdots = 1;

	return the_excerpt_reloaded($excerpt_length, $allowedtags, $filter_type, $use_more_link, $more_link_text, $force_more, $fakeit, $fix_tags, $no_more, $more_tag, $more_link_title, $showdots);
}

function the_excerpt_reloaded($excerpt_length=120, $allowedtags='<a>', $filter_type='none', $use_more_link=true, $more_link_text="(more...)", $force_more=true, $fakeit=1, $fix_tags=true, $no_more=false, $more_tag='div', $more_link_title='Continue reading this entry', $showdots=true) {
	if(preg_match('%^content($|_rss)|^excerpt($|_rss)%', $filter_type)) {
		$filter_type = 'the_' . $filter_type;
	}
	echo get_the_excerpt_reloaded($excerpt_length, $allowedtags, $filter_type, $use_more_link, $more_link_text, $force_more, $fakeit, $fix_tags, $no_more, $more_tag, $more_link_title, $showdots);
}

function get_the_excerpt_reloaded($excerpt_length, $allowedtags, $filter_type, $use_more_link, $more_link_text, $force_more, $fakeit, $fix_tags, $no_more, $more_tag, $more_link_title, $showdots) {
	global $post;

	if (!empty($post->post_password)) { // if there's a password
		if ($_COOKIE['wp-postpass_'.COOKIEHASH] != $post->post_password) { // and it doesn't match cookie
			if(is_feed()) { // if this runs in a feed
				$output = __('There is no excerpt because this is a protected post.');
			} else {
	            $output = get_the_password_form();
			}
		}
		return $output;
	}

	if($fakeit == 2) { // force content as excerpt
		$text = $post->post_content;
	} elseif($fakeit == 1) { // content as excerpt, if no excerpt
		$text = (empty($post->post_excerpt)) ? $post->post_content : $post->post_excerpt;
	} else { // excerpt no matter what
		$text = $post->post_excerpt;
	}

	if($excerpt_length < 0) {
		$output = $text;
	} else {
		if(!$no_more && strpos($text, '<!--more-->')) {
		    $text = explode('<!--more-->', $text, 2);
			$l = count($text[0]);
			$more_link = 1;
		} else {
			$text = explode(' ', $text);
			if(count($text) > $excerpt_length) {
				$l = $excerpt_length;
				$ellipsis = 1;
			} else {
				$l = count($text);
				$more_link_text = '';
				$ellipsis = 0;
			}
		}
		for ($i=0; $i<$l; $i++)
				$output .= $text[$i] . ' ';
	}

	if('all' != $allowedtags) {
		$output = strip_tags($output, $allowedtags);
	}

//	$output = str_replace(array("\r\n", "\r", "\n", "  "), " ", $output);

	$output = rtrim($output, "\s\n\t\r\0\x0B");
    	$output = ($fix_tags) ? balanceTags($output, true) : $output;
	$output .= ($showdots && $ellipsis) ? '...' : '';
	$output = apply_filters($filter_type, $output);

	switch($more_tag) {
		case('div') :
			$tag = 'div';
		break;
		case('span') :
			$tag = 'span';
		break;
		case('p') :
			$tag = 'p';
		break;
		default :
			$tag = 'span';
	}

	if ($use_more_link && $more_link_text) {
		if($force_more) {
			$output .= ' <' . $tag . ' class="more-link"><a href="'. get_permalink($post->ID) . '#more-' . $post->ID .'" title="' . $more_link_title . '">' . $more_link_text . '</a></' . $tag . '>' . "\n";
		} else {
			$output .= ' <' . $tag . ' class="more-link"><a href="'. get_permalink($post->ID) . '" title="' . $more_link_title . '">' . $more_link_text . '</a></' . $tag . '>' . "\n";
		}
	}

	return $output;
}
?>